/* eslint-disable jsx-a11y/label-has-associated-control */
import { GoogleMap, Marker } from '@react-google-maps/api';
import React, { useEffect, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import { useNavigate, useParams } from 'react-router-dom';
import '../../map.css';
import plus from '@/assets/plus.png';
import { useAuth } from '@/lib/auth';
import { propertyInvestmentDetails } from '@/api/propertyInvestment/propertyInvestmentDetails';
import { Investment } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import storage from '@/utils/storage';
import { uploadImage } from '@/api/uploadImage';
import FileViewer from '@/components/Viewer/FileViewer';
import { useSelectFile } from '@/hooks/useSelectFile';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import DraftInput from '@/components/Elements/DraftInput/DraftInput';
import i18next from 'i18next';
const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;
// -------------- google maps --------------------

function Map({
  location,
  addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

// ---------------google maps -------------------

const schema = z.object({
  project_name: z.string().min(1, 'Please enter project name '),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  // location: z.string().min(1, 'Please enter location'),
  target_irr: z.string().min(1, 'Please enter '),
  target_return_on_cost: z.string().min(1, 'Please enter target return cost'),
  target_equity_multiple: z.string().min(1, 'Please enter target equity multiple'),
  estimated_hold_period: z.string().min(1, 'Please enter estimated hold period'),
  funded: z.string().min(1, 'Please enter funded'),
  offered_by: z.string().min(1, 'Please enter offered by'),
  investment_strategy: z.string().min(1, 'Please enter investment strategy'),
  investment_type: z.string().min(1, 'Please enter investment type'),
  estimated_first_distribution: z.string().min(1, 'Please enter estimated first distribution'),
  minimum_investment: z
    .string()
    .min(1, 'Please enter minimum investment')
    .regex(/^\d+$/)
    .transform(Number),
  overview: z.string().min(1, 'Please enter overview'),
  asset_quality: z.string().min(1, 'Please enter asset quality'),
  market: z.string().min(1, 'Please enter market'),
  of_units: z.string().min(1, 'Please enter market'),
  total_building_gross_sf: z.string().min(1, 'Please enter market'),
  first_units_delivered: z.string().min(1, 'Please enter market'),
  land_acquisition_price: z.string().min(1, 'Please enter market'),
  project_stabilization: z.string().min(1, 'Please enter market'),
  total_development_budget: z.string().min(1, 'Please enter market'),
  investment_highlights: z.string().min(1, 'Please enter market'),
  about: z.string().min(1, 'Please enter market'),
  business_plan: z.string().min(1, 'Please enter market'),
  disclaimers: z.string().min(1, 'Please enter market'),
  // -------------------?
  property_type: z.string(),
  about_management: z.string(),
});

type rentValues = {
  image_data: string;
  videos: string;
  documents_data: string;
  project_name: string;
  target_irr: string;
  location: string;
  phone_number: string;
  target_return_on_cost: string;
  target_equity_multiple: string;
  estimated_hold_period: string;
  funded: string;
  offered_by: string;
  investment_strategy: string;
  investment_type: string;
  estimated_first_distribution: string;
  minimum_investment: string;
  overview: string;
  partner: string;
  market: string;
  asset_quality: string;
  is_draft: string;
  of_units: string;
  total_building_gross_sf: string;
  first_units_delivered: string;
  land_acquisition_price: string;
  project_stabilization: string;
  total_development_budget: string;
  investment_highlights: string;
  about: string;
  business_plan: string;
  disclaimers: string;
  property_id: any;
  // -------------------------- new ---------------

  property_type: string;
  management_logo: string;
  about_management: string;
  property_summary: string;
  property_detail: string;
  property_location: string;
  latitude: string;
  longitude: string;
  financial_cap_stack: string;
  financial_debt_assumption: string;
};

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

export const ProjectMoney = () => {
  const { id } = useParams();
  const [idd, setIdd] = useState('');
  const [user, setUser] = useState<Investment>();
  const [locationData, setLocationData] = useState<any>(null);

  // ================================= Property at glanc ==================
  const [propertyItem, setPropertyItem] = useState('');
  const [propertyItemData, setPropertyItemData] = useState('');
  const [propertyGlanceData, setPropertyGlanceData] = useState([]);

  const handleItemChange = (e) => {
    setPropertyItem(e.target.value);
  };

  const handleItemDataChange = (e) => {
    setPropertyItemData(e.target.value);
  };

  const addItem = () => {
    const newItem = {
      id: Date.now(),
      item: propertyItem,
      data: propertyItemData,
    };
    setPropertyGlanceData([...propertyGlanceData, newItem]);
    setPropertyItem('');
    setPropertyItemData('');
  };

  const deleteItem = (id) => {
    const updatedItems = propertyGlanceData.filter((item) => item.id !== id);
    setPropertyGlanceData(updatedItems);
  };

  // ========= p at glance =========================
  const {
    file: videoFile,
    preview: videoPreview,
    handleChange: handleVideoChange,
    cover,
  } = useSelectFile();

  const {
    file: pdfFile,
    preview: pdfPreview,
    handleChange: pdfhandleChange,
    pdfName,
  } = useSelectFile();

  const {
    file: managementLogoFile,
    preview: managementlogoPreview,
    handleChange: managementlogoChange,
  } = useSelectFile();

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await propertyInvestmentDetails(id);
      const userIn = data?.data ?? ({} as Investment);
      setUser(userIn);
      setisLoader(false);
    }
  };

  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
  }, [id]);

  const auth = useAuth();
  const [userSubscribed, setuserSubscribed] = useState();

  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth.user?.has_subscription);
  }, [auth, auth.user?.has_subscription]);

  const navigate = useNavigate();
  const [value, setValue] = useState(null);
  const [address, setAddress] = useState<string>('');
  const [loading, setLoading] = useState(false);

  // const inputFileRef = useRef<HTMLInputElement | null>(null);
  const [is_draft, setis_draft] = useState<string>('False');

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);

  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/project-money/${idd}?type=InvestmentProject`,
  };
  storage.setSubmitFormData(addData);

  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const [isLoader, setisLoader] = useState<boolean>(false);
  const [imageArray, setImageArray] = useState<any>([]);
  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_label: '1',
    latitude: '2',
    longitude: '2',
  });

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  // ----------------- Partner Upload -----------------------

  const {
    images: partnerimages,
    handleChange: partnerhandleChange,
    uploaded: partneruploaded,
    deleteImage: partnerdeleteImage,
    about: partnerabout,
    setAbout: partnersetAbout,
    text: partnertext,
    setText: partnersetText,
    position: partnerPosition,
    setPosition: partnersetPosition,
    linkedin: partnerLinkedin,
    setLinkedin: partnersetLinkedin,
    load: partnerload,
  } = useSelectMultipleFile();

  const [partnerArray, setpartnerArray] = useState<any>([]);

  const deletepartnerImages = (val: any) => {
    const filteredpartnerItems = partnerArray
      .slice(0, val)
      .concat(partnerArray.slice(val + 1, partnerArray.length));
    setpartnerArray(filteredpartnerItems);
  };

  const handlepartnerText = (index: number, val: string) => {
    const textItems = [...partnertext];
    textItems[index] = val;
    partnersetText(textItems);
  };
  const handlepartnerPosition = (index: number, val: string) => {
    const positionItems = [...partnerPosition];
    positionItems[index] = val;
    partnersetPosition(positionItems);
  };
  const handlepartnerLinkedin = (index: number, val: string) => {
    const linkedinItems = [...partnerLinkedin];
    linkedinItems[index] = val;
    partnersetLinkedin(linkedinItems);
  };
  const handlepartnerAbout = (index: number, val: string) => {
    const aboutItems = [...partnerabout];
    aboutItems[index] = val;
    partnersetAbout(aboutItems);
  };

  useEffect(() => {
    if (user) {
      const previousPartnerImage = eval(user?.partner);
      setpartnerArray(previousPartnerImage);
    }
  }, [user]);
  // --------------------------------------------------------------

  const handleSubmit = async (values: rentValues) => {
    setLoading(true);
    let pdfUrl = '';
    if (pdfFile) {
      const response = await uploadImage({ file: pdfFile });
      pdfUrl = response.url;
    } else {
      pdfUrl = user?.documents_data ?? '';
    }

    let managemenrImage = '';
    if (managementLogoFile) {
      const response = await uploadImage({ file: managementLogoFile });
      managemenrImage = response.url;
    }

    let videoUrl = '';

    const newArray = uploaded.map(function (value, index) {
      return { image: value, name: text[index] };
    });

    const image_data = imageArray.concat(newArray);

    if (videoFile) {
      const response = await uploadImage({ file: videoFile });
      videoUrl = response.url;
    } else {
      videoUrl = user?.videos ?? '';
    }

    const newpartnerArray = partneruploaded.map(function (value, index) {
      return { image: value, name: partnertext[index], about: partnerabout[index] };
    });
    const partnerData = partnerArray.concat(newpartnerArray);

    values.videos = videoUrl;
    values.documents_data = pdfUrl;
    values.property_id = id ?? '1';
    values.image_data = JSON.stringify(image_data);
    values.is_draft = is_draft;
    // ---------------
    values.partner = JSON.stringify(partnerData);
    values.management_logo = managemenrImage;
    values.location = locationData;
    values.latitude = '1212';
    values.longitude = '1212';
    setLoading(true);

    id != null
      ? axios
          .post('/customer-api/edit-investment-project', values)
          .then(() => {
            setLoading(false);
            navigate('/user/my-listing');
            showSuccess();
            // navigate('/');
          })
          .catch(() => {
            setLoading(false);
          })
      : axios
          .post('/customer-api/investment-my-project', values)
          .then((response) => {
            setLoading(false);
            showSuccess();
            if (auth.user?.has_subscription == true) {
              setLoading(false);
              navigate('/project-developer');
            } else {
              setIdd(response?.data?.id);
              navigate('/user/subscription');
              setLoading(false);
            }
          })
          .catch(() => {
            setLoading(false);
          });
  };

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Property for Rent submited successfully!',
    });
  };

  return (
    <ContentLayout title="Property for Rent/Sale">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="my-5 d-flex flex-column align-items-center">
        <div className="mt-3 row short-title-rw" style={{ width: '70%' }}>
          <div className="col-12">
            {isLoader ? (
              <EditSalePageLoader />
            ) : (
              <>
                <Card shadow className="shadow-lg p-4">
                  <Form<rentValues, typeof schema>
                    onSubmit={handleSubmit}
                    schema={schema}
                    options={{
                      defaultValues: {
                        ...user,
                        minimum_investment: user?.minimum_investment?.toString(),
                      },
                    }}
                  >
                    {({ register, formState }) => (
                      <>
                        <div className="d-flex flex-column align-items-center text-center">
                          {id != null ? (
                            <>
                              <h1>Edit your Property</h1>
                            </>
                          ) : (
                            <>
                              <h1>Add New Project for money !</h1>
                              <h5>
                                Include as much details and pictures as possible, and set the right
                                price.
                              </h5>
                            </>
                          )}
                          <br />
                          <div className="selectedImagesDiv">
                            <div className="row">
                              <div className="col-md-4">
                                <div className="ms-4">
                                  <h5>Video</h5>
                                  <label htmlFor="videoInput">
                                    <div className="image-box">
                                      {videoPreview ? (
                                        <img
                                          src={cover?.toString() ?? ''}
                                          alt=""
                                          className="profileImage"
                                        />
                                      ) : user?.videos ? (
                                        <p className="smallFile">
                                          <FileViewer file={user?.videos} />
                                        </p>
                                      ) : (
                                        <img src={plus} alt="" width="60" />
                                      )}
                                    </div>
                                  </label>
                                  <input
                                    accept="video/mp4,video/x-m4v,video/*"
                                    onChange={handleVideoChange}
                                    type="file"
                                    id="videoInput"
                                    className="d-none"
                                  />
                                </div>
                              </div>
                              <div className="col-md-8">
                                <h5>Images</h5>

                                <div className="row">
                                  {imageArray.map((item: any, index: number) => (
                                    <div key={index} className="col-md-2 cross-pic">
                                      <div className="image-box">
                                        <button type="button" onClick={() => deleteImages(index)}>
                                          <i className="fa-solid fa-square-xmark pics"></i>
                                        </button>
                                        <img src={item.image} alt="..." />
                                      </div>
                                      {item.name && <h6 className="itemName">{item.name}</h6>}
                                    </div>
                                  ))}

                                  {images.map((item: any, index: number) => (
                                    <div key={index} className="cross-pic">
                                      <div className="image-box">
                                        <button type="button" onClick={() => deleteImage(index)}>
                                          <i className="fa-solid fa-square-xmark pics"></i>
                                        </button>
                                        <img src={item} alt="..." />
                                      </div>
                                      <input
                                        type="text"
                                        id="imageName"
                                        name="imageName"
                                        placeholder="Image name"
                                        onChange={(e) => handleText(index, e.target.value)}
                                        value={text[index]}
                                      />
                                      {/* {item.name && <h6 className="itemName">{item.name}</h6>} */}
                                    </div>
                                  ))}

                                  <div className="col-md-2 col-12">
                                    <div className="padding-r">
                                      <label htmlFor="fileInput1">
                                        <div className="image-box">
                                          {load ? (
                                            <Spinner />
                                          ) : (
                                            <img src={plus} alt="" width="60" />
                                          )}
                                        </div>
                                      </label>
                                      <input
                                        accept="image/*"
                                        onChange={handleChange}
                                        multiple
                                        type="file"
                                        id="fileInput1"
                                        className="d-none"
                                      />
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <br />
                          <hr />
                          <div className="row Partner_Data_Upload">
                            <p className="headingUplod">Upload Partner Data Here</p>
                            {partnerArray?.map((item: any, index: number) => (
                              <div key={index} className="col-md-2 cross-pic">
                                <div className="image-box">
                                  <button type="button" onClick={() => deletepartnerImages(index)}>
                                    <i className="fa-solid fa-square-xmark pics"></i>
                                  </button>
                                  <img src={item.image} alt="..." />
                                </div>
                                {item.name && <h6 className="itemName">{item.name}</h6>}
                                {item.about && <h6 className="itemName">{item.about}</h6>}
                              </div>
                            ))}

                            {partnerimages?.map((item: any, index: number) => (
                              <div key={index} className="cross-pic">
                                <div className="image-box">
                                  <button type="button" onClick={() => partnerdeleteImage(index)}>
                                    <i className="fa-solid fa-square-xmark pics"></i>
                                  </button>
                                  <img src={item} alt="..." />
                                </div>
                                <input
                                  type="text"
                                  id="imagepartnerName"
                                  name="imagepartnerName"
                                  placeholder="Partner name"
                                  onChange={(e) => handlepartnerText(index, e.target.value)}
                                  value={partnertext[index]}
                                />
                                <input
                                  type="text"
                                  id="imagepartnerPosition"
                                  name="imagepartnerPosition"
                                  placeholder="Position"
                                  onChange={(e) => handlepartnerPosition(index, e.target.value)}
                                  value={partnerPosition[index]}
                                />

                                <input
                                  type="text"
                                  id="imagepartnerLinkedin"
                                  name="imagepartnerLinkedin"
                                  placeholder="Linkedin"
                                  onChange={(e) => handlepartnerLinkedin(index, e.target.value)}
                                  value={partnerLinkedin[index]}
                                />

                                <textarea
                                  id="imageBoardAbout"
                                  name="imageBoardAbout"
                                  placeholder="About Member"
                                  onChange={(e) => handlepartnerAbout(index, e.target.value)}
                                  value={partnerabout[index]}
                                  rows={4}
                                />
                              </div>
                            ))}

                            <div className="col-md-2 col-12">
                              <div className="padding-r">
                                <label htmlFor="fileInput4">
                                  <div className="image-box">
                                    {partnerload ? (
                                      <Spinner />
                                    ) : (
                                      <img src={plus} alt="" width="60" />
                                    )}
                                  </div>
                                </label>
                                <input
                                  accept="image/*"
                                  onChange={partnerhandleChange}
                                  multiple
                                  type="file"
                                  id="fileInput4"
                                  className="d-none"
                                />
                              </div>
                            </div>
                          </div>
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Property name"
                            error={formState.errors['project_name']}
                            registration={register('project_name')}
                            placeholder="property_name"
                          />
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label={i18next.t('Asset Quality')}
                            error={formState.errors['asset_quality']}
                            registration={register('asset_quality')}
                          />
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Of Units"
                            error={formState.errors['of_units']}
                            registration={register('of_units')}
                          />{' '}
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label={i18next.t('Property Type')}
                            error={formState.errors['property_type']}
                            registration={register('property_type')}
                          />{' '}
                          <div>
                            <h2>CRUD Example</h2>
                            <div>
                              <label>Property Item: </label>
                              <input type="text" value={propertyItem} onChange={handleItemChange} />
                            </div>
                            <div>
                              <label>Property Item Data: </label>
                              <input
                                type="text"
                                value={propertyItemData}
                                onChange={handleItemDataChange}
                              />
                            </div>
                            <button onClick={addItem}>Add Item</button>
                            <ul>
                              {propertyGlanceData.map((item) => (
                                <li key={item.id}>
                                  {item.item} - {item.data}
                                  <button onClick={() => deleteItem(item.id)}>Delete</button>
                                </li>
                              ))}
                            </ul>
                          </div>
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label="Total Building Gross Sf &#8364;"
                            error={formState.errors['total_building_gross_sf']}
                            registration={register('total_building_gross_sf')}
                          />{' '}
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="First Units Delivered"
                            error={formState.errors['first_units_delivered']}
                            registration={register('first_units_delivered')}
                          />{' '}
                          {/* ====================== MAnagement logo ============ */}
                          <div className=" col-md-4">
                            <h5>Management Logo</h5>
                            <label htmlFor="fileInput22">
                              <div className="image-box">
                                {managementlogoPreview ? (
                                  <img
                                    src={managementlogoPreview}
                                    alt=""
                                    className="profileImage"
                                  />
                                ) : user?.small_company_logo ? (
                                  <img src={user?.small_company_logo} alt="" width="60" />
                                ) : (
                                  <img src={plus} alt="" width="60" />
                                )}
                              </div>
                            </label>
                            <input
                              accept="image/*"
                              onChange={managementlogoChange}
                              type="file"
                              id="fileInput22"
                              className="d-none"
                            />
                          </div>
                          <TextAreaField
                            label="About Management"
                            wrapperClass="w-full"
                            error={formState.errors['about_management']}
                            registration={register('about_management')}
                          ></TextAreaField>
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Land Acquisition Price &#8364;"
                            error={formState.errors['land_acquisition_price']}
                            registration={register('land_acquisition_price')}
                          />{' '}
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Project Stabilization"
                            error={formState.errors['project_stabilization']}
                            registration={register('project_stabilization')}
                          />{' '}
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label="Total Development Budget &#8364;"
                            error={formState.errors['total_development_budget']}
                            registration={register('total_development_budget')}
                          />{' '}
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label={i18next.t('Investment Highlights')}
                            error={formState.errors['investment_highlights']}
                            registration={register('investment_highlights')}
                          />
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Market"
                            error={formState.errors['market']}
                            registration={register('market')}
                          />
                          {/* <div className="document-upload-div">
                            <h5>Select Doccument</h5>
                            <label htmlFor="fileInput">
                              <div>
                                {pdfPreview ? (
                                  <>
                                    {pdfName ? (
                                      <>
                                        <div className="files-box">
                                          <p>{pdfName}</p>
                                        </div>
                                      </>
                                    ) : (
                                      <>
                                        <div className="image-box">
                                          <img src={pdfPreview} alt="" className="profileImage" />
                                        </div>
                                      </>
                                    )}
                                  </>
                                ) : (
                                  <>
                                    <div className="files-box">
                                      <img src={plus} alt="" width="60" />
                                    </div>
                                  </>
                                )}
                              </div>
                            </label>
                            <input
                              accept="pdf/*"
                              onChange={pdfhandleChange}
                              type="file"
                              id="fileInput"
                              className="d-none"
                            />
                          </div> */}
                          <div>
                            <p className="headingUplod">Upload Doccuments here</p>
                            <label htmlFor="fileInput">
                              <div>
                                {pdfPreview ? null : (
                                  <>
                                    {user?.documents_data ? (
                                      <div className="pdfDiv">
                                        <FileViewer file={user?.documents_data} />
                                      </div>
                                    ) : null}
                                  </>
                                )}

                                {pdfPreview ? (
                                  <>
                                    {pdfName ? (
                                      <>
                                        <div className="files-box">
                                          <p>{pdfName}</p>
                                        </div>
                                      </>
                                    ) : (
                                      <>
                                        <div className="image-box">
                                          <img src={pdfPreview} alt="" className="profileImage" />
                                        </div>
                                      </>
                                    )}
                                  </>
                                ) : (
                                  <>
                                    {user?.documents_data ? (
                                      <div className="files-box">
                                        <p>Edit Doccument here .</p>
                                      </div>
                                    ) : (
                                      <div className="files-box">
                                        <img src={plus} alt="" width="60" />
                                      </div>
                                    )}
                                  </>
                                )}
                              </div>
                            </label>
                            <input
                              accept="pdf/*"
                              onChange={pdfhandleChange}
                              type="file"
                              id="fileInput"
                              className="d-none"
                            />
                          </div>
                          <TextAreaField
                            label="About project"
                            wrapperClass="w-full"
                            error={formState.errors['about']}
                            registration={register('about')}
                          ></TextAreaField>
                          <TextAreaField
                            label={i18next.t('Business Plan')}
                            wrapperClass="w-full"
                            error={formState.errors['business_plan']}
                            registration={register('business_plan')}
                          ></TextAreaField>
                          <TextAreaField
                            label="disclaimers Project"
                            wrapperClass="w-full"
                            error={formState.errors['disclaimers']}
                            registration={register('disclaimers')}
                          ></TextAreaField>
                          <TextAreaField
                            label="Overview Project"
                            wrapperClass="w-full"
                            error={formState.errors['overview']}
                            registration={register('overview')}
                          ></TextAreaField>
                          {/* <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Partner's name"
                            error={formState.errors['partner']}
                            registration={register('partner')}
                          /> */}
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label={`${i18next.t('Minimum Investment')} &#8364;`}
                            error={formState.errors['minimum_investment']}
                            registration={register('minimum_investment')}
                       
                          />
                          <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Offered By"
                            error={formState.errors['offered_by']}
                            registration={register('offered_by')}
                          />
                          <TextAreaField
                            label={i18next.t('Investment Strategy')}
                            wrapperClass="w-full"
                            error={formState.errors['investment_strategy']}
                            registration={register('investment_strategy')}
                          ></TextAreaField>
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label="Estimated first Distribution &#8364;"
                            error={formState.errors['estimated_first_distribution']}
                            registration={register('estimated_first_distribution')}
                          />
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label={i18next.t('Estimated Hold Period')}
                            error={formState.errors['estimated_hold_period']}
                            registration={register('estimated_hold_period')}
                            placeholder="Finder fee"
                          />
                          <SelectField
                            wrapperClass="w-full"
                            label={i18next.t('Investment Type')}
                            error={formState.errors['investment_type']}
                            registration={register('investment_type')}
                            placeholder="3"
                            options={[
                              { label: 1, value: 1 },
                              { label: 2, value: 2 },
                              { label: 3, value: 3 },
                              { label: 4, value: 4 },
                              { label: 5, value: 5 },
                            ]}
                          />
                          <SelectField
                            wrapperClass="w-full"
                            label={i18next.t('Funded')}
                            error={formState.errors['funded']}
                            registration={register('funded')}
                            placeholder="3"
                            options={[
                              { label: 'Yes', value: 'Yes' },
                              { label: 'No', value: 'No' },
                            ]}
                          />
                          <InputPhone
                            floating
                            error={formState.errors['phone_number']}
                            registration={register('phone_number')}
                          />
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label="Target Return On Cost &#8364;"
                            error={formState.errors['target_return_on_cost']}
                            registration={register('target_return_on_cost')}
                            placeholder="Property reference id"
                          />
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label={i18next.t('Target Equity Multiple')}
                            error={formState.errors['target_equity_multiple']}
                            registration={register('target_equity_multiple')}
                            placeholder="213"
                          />
                          <InputField
                            type="number"
                            wrapperClass="w-full"
                            label="Target irr (in %)"
                            error={formState.errors['target_irr']}
                            registration={register('target_irr')}
                            placeholder="Maintainance Fee &#8364;"
                          />
                          {/* <InputField
                            type="text"
                            wrapperClass="w-full"
                            label="Location"
                            error={formState.errors['location']}
                            registration={register('location')}
                          /> */}
                          <DraftInput html={locationData} setHtml={setLocationData} />
                          <br />
                          <h5>Is the pin in the right location?</h5>
                          <br />
                          <div style={{ width: '100%' }}>
                            <div style={{ width: '100%', height: '80%' }}>
                              <Map
                                location={location}
                                setAddressDetails={setAddressDetails}
                                addressDetails={addressDetails}
                              />
                            </div>
                          </div>
                          <br />
                          <div className="col-12">
                            <div className="pt-2 pb-2">
                              <GooglePlacesAutocomplete
                                selectProps={{
                                  defaultInputValue: '',
                                  value,
                                  onChange: handleChangeLocation,
                                }}
                              />
                            </div>
                          </div>
                          <br />
                          <div className="d-flex justify-content-end mt-4">
                            {userSubscribed == true ? (
                              <>
                                {' '}
                                <Button
                                  isLoading={loading}
                                  type="submit"
                                  variant="primary"
                                  size="md"
                                  className="mt-2 w-full"
                                >
                                  Submit
                                </Button>
                              </>
                            ) : (
                              <>
                                {' '}
                                <Button
                                  isLoading={loading}
                                  type="submit"
                                  variant="primary"
                                  size="md"
                                  className="mt-2 w-full"
                                >
                                  Subscribe
                                </Button>
                              </>
                            )}
                          </div>
                        </div>
                      </>
                    )}
                  </Form>
                </Card>
              </>
            )}
          </div>
        </div>
      </div>
    </ContentLayout>
  );
};
